const axios = require('axios');
const { esCalibreValidoCereza } = require('./validarCalibre.helper');

async function consultarDetallesCharg(charg, token, RFC_BASE) {
    try {
        const payload = {
            RFC: "ZRFC_SJF_10001",
            getBase: false,
            INPUT: {
                IV_LIB_UTIL: "",
                IR_CHARG: [{ SIGN: "I", OPTION: "EQ", LOW: charg, HIGH: charg }],
                IR_LGORT: [{ SIGN: "I", OPTION: "EQ", STLOC_LOW: "A050", STLOC_HIGH: "A050" }],
                IR_CLASS: [{ HIGH: "ZCLASE_CEREZA", LOW: "ZCLASE_CEREZA", OPTION: "EQ", SIGN: "I" }],
                IR_MTART: [
                    { HIGH: "FERT", LOW: "FERT", OPTION: "EQ", SIGN: "I" },
                    { HIGH: "HALB", LOW: "HALB", OPTION: "EQ", SIGN: "I" }
                ],
                IR_ATNAM: [
                    { HIGH: "ZCEREZA_CATEGORIA", LOW: "ZCEREZA_CATEGORIA", OPTION: "EQ", SIGN: "I" },
                    { HIGH: "ZCEREZA_VARIEDAD", LOW: "ZCEREZA_VARIEDAD", OPTION: "EQ", SIGN: "I" },
                    { HIGH: "ZREFERENCIA", LOW: "ZREFERENCIA", OPTION: "EQ", SIGN: "I" },
                    { HIGH: "ZPALLET", LOW: "ZPALLET", OPTION: "EQ", SIGN: "I" },
                    { HIGH: "ZORDEN_PROCESO_REL", LOW: "ZORDEN_PROCESO_REL", OPTION: "EQ", SIGN: "I" },
                    { HIGH: "ZPEDIDO_RELACIONADO", LOW: "ZPEDIDO_RELACIONADO", OPTION: "EQ", SIGN: "I" },
                    { HIGH: "ZCALIBRE_REAL", LOW: "ZCALIBRE_REAL", OPTION: "EQ", SIGN: "I" },
                    { HIGH: "ZSAG_CSG", LOW: "ZSAG_CSG", OPTION: "EQ", SIGN: "I" },
                    { HIGH: "ZCEREZA_CALIBRE", LOW: "ZCEREZA_CALIBRE", OPTION: "EQ", SIGN: "I" }
                ]
            }
        };

        // console.log('CHARG request:', {
        //     url: RFC_BASE,
        //     token,
        //     payload
        // });

        const response = await axios.post(`${RFC_BASE}`, payload, {
            headers: { Authorization: token, 'Content-Type': 'application/json' }
        });

        console.log(`Detalle CHARG desde consultar detalles ${charg}:`, response.data);

        const item = response.data?.data?.ZRFC_SJF_10001?.TABLES?.RESPONSE?.item;
        if (!item) return null;

        const valores = item.VALORES?.split(';') || [];

        let calibre = valores[6] || null;

        // Validar calibre si es de cereza
        if(!(await esCalibreValidoCereza(calibre))) {
            calibre = valores[8] || null;
            console.log(`Calibre alternativo para CHARG ${charg}:`, calibre);
        }

        return {
            categoria: valores[0] || null,
            variedad: valores[1] || null,
            referencia: valores[2] || null,
            pallet: valores[3] || null,
            ordenProceso: valores[4] || null,
            pedidoRelacionado: valores[5] || null,
            calibre: calibre,
            csg: valores[7] || null,
            charg: charg,
            matnr: item.MATNR,
            stock: item.LABST
        };

    } catch (err) {
        console.log(`Error CHARG ${charg}:`, err.message);
        return null;
    }
}

module.exports = { consultarDetallesCharg };
