const { ProcesoCalibre } = require('../models');

/**
 * Valida si un valor es un calibre válido para cerezas
 * @param {string} valor - Valor a validar
 * @returns {Promise<boolean>} true si es válido
 */

async function esCalibreValidoCereza(valor) {
    if (!valor || !valor.trim()) return false;
    
    try {
        const calibres = await ProcesoCalibre.findAll({
            where: { gen_fk_tbl_especie_gen_idtbl_especie: 8 },
            attributes: ['gen_nombre_calibre'],
            raw: true
        });
        
        const nombresCalibre = calibres.map(c => c.gen_nombre_calibre);
        return nombresCalibre.includes(valor.trim());
        
    } catch (error) {
        console.error('Error validando calibre de cereza:', error);
        return false;
    }
}

module.exports = {
    esCalibreValidoCereza
};