const { DataTypes } = require("sequelize");
const { sequelize } = require('../config/database');

const Pais = sequelize.define('Pais', {
    gen_id_pais: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
        field: "gen_id_pais"
    },
    gen_nombre_pais: {
        type: DataTypes.STRING(255),
        allowNull: false,
        field: "gen_nombre_pais"
    },
    gen_cod_pais: {
        type: DataTypes.STRING(45),
        allowNull: false,
        field: "gen_cod_pais"
    },
    gen_registro_pais: {
        type: DataTypes.DATE,
        allowNull: true,
        field: "gen_registro_pais"
    },
}, {
    tableName: "tbl_pais",
    timestamps: false, // Si no usas createdAt y updatedAt
});

module.exports = { Pais };
