const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');
const { ProcesoMaterial } = require('../models/procesoMaterial.model');
const { ProcesoHeader } = require('../models/procesoHeader.model');

const ProcesoIn = sequelize.define('ProcesoIn', {
    gen_idtbl_in_op: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
        field: 'gen_idtbl_in_op'
    },
    gen_cantidad_in_op: {
        type: DataTypes.FLOAT,
        allowNull: false,
        field: 'gen_cantidad_in_op'
    },
    gen_referencia: {
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'gen_referencia'
    },
    gen_fk_tbl_header_op_idtbl_header_op: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_header_op_idtbl_header_op',
        references: {
            model: ProcesoHeader,
            key: 'gen_idtbl_header_op',
        },
    },
    gen_fk_tbl_material_idtbl_material: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_material_idtbl_material',
        references: {
            model: ProcesoMaterial,
            key: 'gen_idtbl_material',
        },
    },
}, {
    tableName: 'tbl_in_op',
    timestamps: false,
});

module.exports = {
    ProcesoIn
}