const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');

const ProcesoMaterial = sequelize.define('ProcesoMaterial', {
    gen_idtbl_material: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
        field: 'gen_idtbl_material'
    },
    gen_nombre_material: {
        type: DataTypes.STRING(45),
        allowNull: false,
        field: 'gen_nombre_material'
    },
    gen_um_material: {
        type: DataTypes.STRING(45),
        allowNull: false,
        field: 'gen_um_material'
    },
    gen_tipo_material: {
        type: DataTypes.STRING(45),
        allowNull: false,
        field: 'gen_tipo_material'
    },
    gen_total_kg: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_total_kg'
    },
}, {
    tableName: 'tbl_material',
    timestamps: false,
});

module.exports = {
    ProcesoMaterial
}