const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');

const ProcesoSetup = sequelize.define('ProcesoSetup', {
    idtbl_proceso_setup: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
        field: 'idtbl_proceso_setup'
    },
    estado: {
        type: DataTypes.STRING(500),
        allowNull: true,
        field: 'estado'
    },
    material_orden: {
        type: DataTypes.STRING(500),
        allowNull: true,
        field: 'material_orden'
    },
    kilos: {
        type: DataTypes.FLOAT,
        allowNull: true,
        field: 'kilos'
    },
    asignacion_id: {
        type: DataTypes.STRING(500),
        allowNull: true,
        field: 'asignacion_id'
    },
    orden: {
        type: DataTypes.STRING(500),
        allowNull: true,
        field: 'orden'
    },
    fecha_orden: {
        type: DataTypes.DATE,
        allowNull: true,
        field: 'fecha_orden'
    },
    centro: {
        type: DataTypes.STRING(500),
        allowNull: true,
        field: 'centro'
    },
    estado_sincronizacion: {
        type: DataTypes.ENUM('0', '1', '2'),
        allowNull: true,
        defaultValue: '0',
        comment: '0: pendiente, 1: procesado, 2: error'
    },
}, {
    tableName: 'tbl_proceso_setup',
    timestamps: false,
});

module.exports = {
    ProcesoSetup
}