const { DataTypes } = require('sequelize');
const { sequelize } = require('../config/database');
const { RecepcionHeader } =  require('../models/recepcionHeader.model');
const { Predio } =  require('../models/predio.model');

const RecepcionDetail = sequelize.define('RecepcionDetail', {
    gen_idtbl_recepcion_detail: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
        field: 'gen_idtbl_recepcion_detail'
    },
    gen_fk_tbl_recepcion_header_idtbl_recepcion: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'gen_fk_tbl_recepcion_header_idtbl_recepcion',
        references: {
            model: RecepcionHeader,
            key: 'gen_idtbl_recepcion',
        },
    },
    gen_fk_tbl_predio_idtbl_predio: {
        type: DataTypes.INTEGER,
        allowNull: true,
        field: 'gen_fk_tbl_predio_idtbl_predio',
        references: {
            model: Predio,
            key: 'gen_idtbl_predio:',
        },
    },
    gen_batch_recepcion_detail: {
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'gen_batch_recepcion_detail'
    },
    gen_cantidad_recepcion_detail: {
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'gen_cantidad_recepcion_detail'
    },
    gen_um_recepcion_detail: {
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'gen_um_recepcion_detail'
    },
    gen_material_recepcion_detail: {
        type: DataTypes.STRING(45),
        allowNull: true,
        field: 'gen_material_recepcion_detail'
    },
    fk_tbl_variedad_idtbl_variedad: {
        type: DataTypes.INTEGER,
        allowNull: true,
        field: 'fk_tbl_variedad_idtbl_variedad',
        references: {
            model: 'tbl_variedad',
            key: 'idtbl_variedad',
        }
    }
}, {
    tableName: 'tbl_recepcion_detail',
    timestamps: false,
});

module.exports = { RecepcionDetail };